/*
 * Decompiled with CFR 0.152.
 */
package me.alphamode.star.client.renderers;

import me.alphamode.star.mixin.sodium.FluidRendererAccessor;
import me.alphamode.star.world.fluids.DirectionalFluid;
import me.jellysquid.mods.sodium.client.model.color.ColorProvider;
import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadViewMutable;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.FluidRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.DefaultMaterials;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.Material;
import me.jellysquid.mods.sodium.client.util.DirectionUtil;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;

public class SodiumUpsideDownFluidRenderer {
    protected final FluidRendererAccessor fluidRenderer;

    public SodiumUpsideDownFluidRenderer(FluidRenderer fluidRenderer) {
        this.fluidRenderer = (FluidRendererAccessor)fluidRenderer;
    }

    private float fluidHeightUpsideDown(class_1920 world, DirectionalFluid fluid, class_2338 blockPos) {
        class_2680 blockState = world.method_8320(blockPos);
        class_3610 fluidState = blockState.method_26227();
        if (fluid.method_15780(fluidState.method_15772())) {
            class_3610 fluidStateUp = world.method_8316(blockPos.method_10093(fluid.getFlowDirection().method_10153()));
            return fluid.method_15780(fluidStateUp.method_15772()) ? 1.0f : fluidState.method_20785();
        }
        return !blockState.method_51367() ? 0.0f : -1.0f;
    }

    public void renderUpsideDown(WorldSlice world, class_3610 fluidState, class_2338 pos, class_2338 offset, ChunkBuildBuffers buffers, FluidRenderHandler handler) {
        Material material = DefaultMaterials.forFluidState((class_3610)fluidState);
        ChunkModelBuilder meshBuilder = buffers.get(material);
        int posX = pos.method_10263();
        int posY = pos.method_10264();
        int posZ = pos.method_10260();
        DirectionalFluid fluid = (DirectionalFluid)fluidState.method_15772();
        boolean sfUp = this.fluidRenderer.callIsFluidOccluded((class_1920)world, posX, posY, posZ, fluid.getFlowDirection().method_10153(), (class_3611)fluid);
        boolean sfDown = this.fluidRenderer.callIsFluidOccluded((class_1920)world, posX, posY, posZ, fluid.getFlowDirection(), (class_3611)fluid) || !this.fluidRenderer.callIsSideExposed((class_1920)world, posX, posY, posZ, fluid.getFlowDirection(), 0.8888889f);
        boolean sfNorth = this.fluidRenderer.callIsFluidOccluded((class_1920)world, posX, posY, posZ, class_2350.field_11043, (class_3611)fluid);
        boolean sfSouth = this.fluidRenderer.callIsFluidOccluded((class_1920)world, posX, posY, posZ, class_2350.field_11035, (class_3611)fluid);
        boolean sfWest = this.fluidRenderer.callIsFluidOccluded((class_1920)world, posX, posY, posZ, class_2350.field_11039, (class_3611)fluid);
        boolean sfEast = this.fluidRenderer.callIsFluidOccluded((class_1920)world, posX, posY, posZ, class_2350.field_11034, (class_3611)fluid);
        if (!(sfUp && sfDown && sfEast && sfWest && sfNorth && sfSouth)) {
            class_1058 sprite;
            float h4;
            float h3;
            float h2;
            float h1;
            boolean isWater = fluidState.method_15767(class_3486.field_15517);
            ColorProvider<class_3610> colorProvider = this.fluidRenderer.callGetColorProvider((class_3611)fluid, handler);
            class_1058[] sprites = handler.getFluidSprites((class_1920)world, pos, fluidState);
            float fluidHeight = this.fluidHeightUpsideDown((class_1920)world, fluid, pos);
            if (fluidHeight >= 1.0f) {
                h1 = 1.0f;
                h2 = 1.0f;
                h3 = 1.0f;
                h4 = 1.0f;
            } else {
                float north1 = this.fluidHeightUpsideDown((class_1920)world, fluid, pos.method_10095());
                float south1 = this.fluidHeightUpsideDown((class_1920)world, fluid, pos.method_10072());
                float east1 = this.fluidHeightUpsideDown((class_1920)world, fluid, pos.method_10078());
                float west1 = this.fluidHeightUpsideDown((class_1920)world, fluid, pos.method_10067());
                h1 = this.fluidRenderer.callFluidCornerHeight((class_1920)world, (class_3611)fluid, fluidHeight, north1, west1, pos.method_10093(class_2350.field_11043).method_10093(class_2350.field_11039));
                h2 = this.fluidRenderer.callFluidCornerHeight((class_1920)world, (class_3611)fluid, fluidHeight, south1, west1, pos.method_10093(class_2350.field_11035).method_10093(class_2350.field_11039));
                h3 = this.fluidRenderer.callFluidCornerHeight((class_1920)world, (class_3611)fluid, fluidHeight, south1, east1, pos.method_10093(class_2350.field_11035).method_10093(class_2350.field_11034));
                h4 = this.fluidRenderer.callFluidCornerHeight((class_1920)world, (class_3611)fluid, fluidHeight, north1, east1, pos.method_10093(class_2350.field_11043).method_10093(class_2350.field_11034));
            }
            ModelQuadViewMutable quad = this.fluidRenderer.getQuad();
            LightMode lightMode = isWater && class_310.method_1588() ? LightMode.SMOOTH : LightMode.FLAT;
            LightPipeline lighter = this.fluidRenderer.getLighters().getLighter(lightMode);
            quad.setFlags(0);
            if (!sfUp && this.fluidRenderer.callIsSideExposed((class_1920)world, posX, posY, posZ, fluid.getFlowDirection(), Math.min(Math.min(h1, h2), Math.min(h3, h4)))) {
                float v4;
                float u4;
                float v3;
                float u3;
                float v2;
                float u2;
                float v1;
                float u1;
                ModelQuadFacing facing;
                h1 -= FluidRendererAccessor.getEPSILON();
                h2 -= FluidRendererAccessor.getEPSILON();
                h3 -= FluidRendererAccessor.getEPSILON();
                h4 -= FluidRendererAccessor.getEPSILON();
                class_243 velocity = fluidState.method_15758((class_1922)world, pos);
                if (velocity.field_1352 == 0.0 && velocity.field_1350 == 0.0) {
                    sprite = sprites[0];
                    facing = ModelQuadFacing.POS_Y;
                    u1 = sprite.method_4580(0.0);
                    v1 = sprite.method_4570(0.0);
                    u2 = u1;
                    v2 = sprite.method_4570(16.0);
                    u3 = sprite.method_4580(16.0);
                    v3 = v2;
                    u4 = u3;
                    v4 = v1;
                } else {
                    sprite = sprites[1];
                    facing = ModelQuadFacing.UNASSIGNED;
                    float dir = (float)class_3532.method_15349((double)velocity.field_1350, (double)velocity.field_1352) - 1.5707964f;
                    float sin = class_3532.method_15374((float)dir) * 0.25f;
                    float cos = class_3532.method_15362((float)dir) * 0.25f;
                    u1 = sprite.method_4580((double)(8.0f + (-cos - sin) * 16.0f));
                    v1 = sprite.method_4570((double)(8.0f + (-cos + sin) * 16.0f));
                    u2 = sprite.method_4580((double)(8.0f + (-cos + sin) * 16.0f));
                    v2 = sprite.method_4570((double)(8.0f + (cos + sin) * 16.0f));
                    u3 = sprite.method_4580((double)(8.0f + (cos + sin) * 16.0f));
                    v3 = sprite.method_4570((double)(8.0f + (cos - sin) * 16.0f));
                    u4 = sprite.method_4580((double)(8.0f + (cos - sin) * 16.0f));
                    v4 = sprite.method_4570((double)(8.0f + (-cos - sin) * 16.0f));
                }
                float uAvg = (u1 + u2 + u3 + u4) / 4.0f;
                float vAvg = (v1 + v2 + v3 + v4) / 4.0f;
                float s1 = (float)sprites[0].method_45851().method_45807() / (sprites[0].method_4577() - sprites[0].method_4594());
                float s2 = (float)sprites[0].method_45851().method_45815() / (sprites[0].method_4575() - sprites[0].method_4593());
                float s3 = 4.0f / Math.max(s2, s1);
                u1 = class_3532.method_16439((float)s3, (float)u1, (float)uAvg);
                u2 = class_3532.method_16439((float)s3, (float)u2, (float)uAvg);
                u3 = class_3532.method_16439((float)s3, (float)u3, (float)uAvg);
                u4 = class_3532.method_16439((float)s3, (float)u4, (float)uAvg);
                v1 = class_3532.method_16439((float)s3, (float)v1, (float)vAvg);
                v2 = class_3532.method_16439((float)s3, (float)v2, (float)vAvg);
                v3 = class_3532.method_16439((float)s3, (float)v3, (float)vAvg);
                v4 = class_3532.method_16439((float)s3, (float)v4, (float)vAvg);
                quad.setSprite(sprite);
                this.fluidRenderer.callSetVertex(quad, 0, 0.0f, 1.0f - h1, 0.0f, u1, v1);
                this.fluidRenderer.callSetVertex(quad, 1, 0.0f, 1.0f - h2, 1.0f, u2, v2);
                this.fluidRenderer.callSetVertex(quad, 2, 1.0f, 1.0f - h3, 1.0f, u3, v3);
                this.fluidRenderer.callSetVertex(quad, 3, 1.0f, 1.0f - h4, 0.0f, u4, v4);
                this.fluidRenderer.callUpdateQuad((ModelQuadView)quad, world, pos, lighter, fluid.getFlowDirection().method_10153(), 1.0f, colorProvider, fluidState);
                this.fluidRenderer.callWriteQuad(meshBuilder, material, offset, (ModelQuadView)quad, facing, false);
                if (fluidState.method_15756((class_1922)world, (class_2338)this.fluidRenderer.getScratchPos().method_10103(posX, posY + 1, posZ))) {
                    this.fluidRenderer.callWriteQuad(meshBuilder, material, offset, (ModelQuadView)quad, ModelQuadFacing.NEG_Y, false);
                }
            }
            if (!sfDown) {
                float yOffset = 1.0f - FluidRendererAccessor.getEPSILON();
                sprite = sprites[0];
                float minU = sprite.method_4594();
                float maxU = sprite.method_4577();
                float minV = sprite.method_4593();
                float maxV = sprite.method_4575();
                quad.setSprite(sprite);
                this.fluidRenderer.callSetVertex(quad, 0, 0.0f, yOffset, 1.0f, minU, maxV);
                this.fluidRenderer.callSetVertex(quad, 1, 0.0f, yOffset, 0.0f, minU, minV);
                this.fluidRenderer.callSetVertex(quad, 2, 1.0f, yOffset, 0.0f, maxU, minV);
                this.fluidRenderer.callSetVertex(quad, 3, 1.0f, yOffset, 1.0f, maxU, maxV);
                this.fluidRenderer.callUpdateQuad((ModelQuadView)quad, world, pos, lighter, fluid.getFlowDirection(), 1.0f, colorProvider, fluidState);
                this.fluidRenderer.callWriteQuad(meshBuilder, material, offset, (ModelQuadView)quad, ModelQuadFacing.NEG_Y, false);
            }
            this.fluidRenderer.getQuad().setFlags(4);
            block6: for (class_2350 dir : DirectionUtil.HORIZONTAL_DIRECTIONS) {
                class_2338.class_2339 adjPos;
                class_2680 adjBlock;
                float z2;
                float z1;
                float x2;
                float x1;
                float c2;
                float c1;
                float yOffset = 1.0f;
                switch (dir) {
                    case field_11043: {
                        if (sfNorth) continue block6;
                        c1 = h4;
                        c2 = h1;
                        x1 = 1.0f;
                        x2 = 0.0f;
                        z2 = z1 = FluidRendererAccessor.getEPSILON();
                        break;
                    }
                    case field_11035: {
                        if (sfSouth) continue block6;
                        c1 = h2;
                        c2 = h3;
                        x1 = 0.0f;
                        x2 = 1.0f;
                        z2 = z1 = 1.0f - FluidRendererAccessor.getEPSILON();
                        break;
                    }
                    case field_11039: {
                        if (sfWest) continue block6;
                        c1 = h1;
                        c2 = h2;
                        x2 = x1 = FluidRendererAccessor.getEPSILON();
                        z1 = 0.0f;
                        z2 = 1.0f;
                        break;
                    }
                    case field_11034: {
                        if (sfEast) continue block6;
                        c1 = h3;
                        c2 = h4;
                        x2 = x1 = 1.0f - FluidRendererAccessor.getEPSILON();
                        z1 = 1.0f;
                        z2 = 0.0f;
                        break;
                    }
                    default: {
                        continue block6;
                    }
                }
                if (!this.fluidRenderer.callIsSideExposed((class_1920)world, posX, posY, posZ, dir, Math.max(c1, c2))) continue;
                int adjX = posX + dir.method_10148();
                int adjY = posY + dir.method_10164();
                int adjZ = posZ + dir.method_10165();
                class_1058 sprite2 = sprites[1];
                boolean isOverlay = false;
                if (sprites.length > 2 && FluidRenderHandlerRegistry.INSTANCE.isBlockTransparent((adjBlock = world.method_8320((class_2338)(adjPos = this.fluidRenderer.getScratchPos().method_10103(adjX, adjY, adjZ)))).method_26204())) {
                    sprite2 = sprites[2];
                    isOverlay = true;
                }
                float u1 = sprite2.method_4580(0.0);
                float u2 = sprite2.method_4580(8.0);
                float v1 = sprite2.method_4570((double)((1.0f - c1) * 16.0f * 0.5f));
                float v2 = sprite2.method_4570((double)((1.0f - c2) * 16.0f * 0.5f));
                float v3 = sprite2.method_4570(8.0);
                quad.setSprite(sprite2);
                this.fluidRenderer.callSetVertex(quad, 0, x2, 1.0f - c2, z2, u2, v2);
                this.fluidRenderer.callSetVertex(quad, 1, x2, yOffset, z2, u2, v3);
                this.fluidRenderer.callSetVertex(quad, 2, x1, yOffset, z1, u1, v3);
                this.fluidRenderer.callSetVertex(quad, 3, x1, 1.0f - c1, z1, u1, v1);
                float br = dir.method_10166() == class_2350.class_2351.field_11051 ? 0.8f : 0.6f;
                ModelQuadFacing facing = ModelQuadFacing.fromDirection((class_2350)dir);
                this.fluidRenderer.callUpdateQuad((ModelQuadView)quad, world, pos, lighter, dir, br, colorProvider, fluidState);
                this.fluidRenderer.callWriteQuad(meshBuilder, material, offset, (ModelQuadView)quad, facing, false);
                if (isOverlay) continue;
                this.fluidRenderer.callWriteQuad(meshBuilder, material, offset, (ModelQuadView)quad, facing.getOpposite(), true);
            }
        }
    }
}

